package com.ejie.ab04b.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.TipoExpedienteFolderEnum;
import com.ejie.ab04b.dao.NumeracionExpedienteDao;
import com.ejie.ab04b.dao.OS3Dao;
import com.ejie.ab04b.dao.temp.DocumentosOS3TempDao;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.model.ComunicacionPrl;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.DocumentoOS3;
import com.ejie.ab04b.model.NumeracionExpediente;
import com.ejie.ab04b.model.OS3;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * OS3ServiceImpl generated by UDA, 28-feb-2017 11:23:12.
 * 
 * @author UDA
 */

@Service(value = "OS3Service")
public class OS3ServiceImpl implements OS3Service {

	@Autowired()
	private OS3Dao os3Dao;

	@Autowired()
	private DatosLocalizacionService datosLocalizacionService;

	@Autowired()
	private DatosNotificacionService datosNotificacionService;

	@Autowired()
	private NumeracionExpedienteDao numeracionExpedienteDao;

	@Autowired()
	private DocumentosOS3TempDao documentosOS3TempDao;

	/**
	 * Inserts a single row in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00 Ab0461s00
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @return the os3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS3 add(OS3 ab0461s00) {
		return this.os3Dao.add(ab0461s00);
	}

	/**
	 * Updates a single row in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00 Ab0461s00
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @return the os3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS3 update(OS3 ab0461s00) {
		return this.os3Dao.update(ab0461s00);
	}

	/**
	 * Finds a single row in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00 Ab0461s00
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @return the os3
	 */
	public OS3 find(OS3 ab0461s00) {
		return (OS3) this.os3Dao.find(ab0461s00);
	}

	/**
	 * Deletes a single row in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(OS3 ab0461s00) {
		this.os3Dao.remove(ab0461s00);
	}

	/**
	 * Busca los datos de registro.
	 * 
	 * os3 the os 3 ComunicacionApertura
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	public OS3 findDatosRegistro(OS3 os3) {
		return this.os3Dao.findDatosRegistro(os3);
	}

	/**
	 * Finds a list of rows in the Ab0461s00 table.
	 * 
	 * ab0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto List<Ab0461s00>
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<OS3> findAll(OS3 ab0461s00, JQGridRequestDto jqGridRequestDto) {
		return (List<OS3>) this.os3Dao.findAll(ab0461s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0461s00 table using like.
	 * 
	 * ab0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0461s00>
	 * 
	 * @param ab0461s00
	 *            the ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<OS3> findAllLike(OS3 ab0461s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<OS3>) this.os3Dao.findAllLike(ab0461s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Finds a list of rows in the Ab0429s00 table.
	 * 
	 * ab0429s00 Ab0429s00
	 * 
	 * List<Ab0429s00>
	 * 
	 * @param ab0429s00
	 *            the ab 0429 s 00
	 * @return the list
	 */
	public List<DocumentoOS3> findAllDocumentosOS3TipoTemp(
			DocumentoOS3 ab0429s00) {
		return (List<DocumentoOS3>) this.documentosOS3TempDao
				.buscarDocumentosOS3TempTipo(ab0429s00);
	}

	/**
	 * Finds a list of rows in the Ab0429s00 table.
	 * 
	 * ab0429s00 Ab0429s00
	 * 
	 * List<Ab0429s00>
	 * 
	 * @param ab0429s00
	 *            the ab 0429 s 00
	 * @return the list
	 */
	public List<DocumentoOS3> buscarDocumentosOS3Temp(DocumentoOS3 ab0429s00) {
		return (List<DocumentoOS3>) this.documentosOS3TempDao
				.buscarDocumentosOS3Temp(ab0429s00);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0461s00 table.
	 * 
	 * filterAb0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean
	 * 
	 * @param filterAb0461s00
	 *            the filter ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	public void removeMultiple(OS3 filterAb0461s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.os3Dao.removeMultiple(filterAb0461s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab0461s00 table.
	 * 
	 * filterAb0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<Ab0461s00>
	 * 
	 * @param filterAb0461s00
	 *            the filter ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<OS3> filter(OS3 filterAb0461s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<OS3> listaAb0461s00 = this.os3Dao.findAllLike(filterAb0461s00,
				jqGridRequestDto, false);
		Long recordNum = this.os3Dao.findAllLikeCount(
				filterAb0461s00 != null ? filterAb0461s00 : new OS3(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<OS3>> reorderSelection = this.os3Dao
					.reorderSelection(filterAb0461s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<OS3>(jqGridRequestDto, recordNum,
					listaAb0461s00, reorderSelection);
		}
		return new JQGridResponseDto<OS3>(jqGridRequestDto, recordNum,
				listaAb0461s00);
	}

	/**
	 * Searches rows in the Ab0461s00 table.
	 * 
	 * filterAb0461s00 Ab0461s00 searchAb0461s00 Ab0461s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0461s00>>
	 * 
	 * @param filterAb0461s00
	 *            the filter ab 0461 s 00
	 * @param searchAb0461s00
	 *            the search ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<TableRowDto<OS3>> search(OS3 filterAb0461s00,
			OS3 searchAb0461s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.os3Dao.search(filterAb0461s00, searchAb0461s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0461s00 table.
	 * 
	 * filterAb0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Object
	 * 
	 * @param filterAb0461s00
	 *            the filter ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	public Object reorderSelection(OS3 filterAb0461s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.os3Dao.reorderSelection(filterAb0461s00, jqGridRequestDto,
				startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab0461s00 table.
	 * 
	 * filterAb0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<JerarquiaDto<Ab0461s00>>
	 * 
	 * @param filterAb0461s00
	 *            the filter ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<OS3>> jerarquia(OS3 filterAb0461s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<JerarquiaDto<OS3>> listaAb0461s00 = this.os3Dao
				.findAllLikeJerarquia(filterAb0461s00, jqGridRequestDto);
		Long recordNum = this.os3Dao.findAllLikeCountJerarquia(filterAb0461s00,
				jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<OS3>>(jqGridRequestDto,
				recordNum, listaAb0461s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab0461s00 table.
	 * 
	 * filterAb0461s00 Ab0461s00 jqGridRequestDto JQGridRequestDto
	 * JQGridResponseDto<JerarquiaDto<Ab0461s00>>
	 * 
	 * @param filterAb0461s00
	 *            the filter ab 0461 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<OS3>> jerarquiaChildren(
			OS3 filterAb0461s00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<OS3>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<OS3>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.os3Dao.findAllChild(filterAb0461s00, jqGridRequestDto));
		return jqGridResponseDto;
	}

	/**
	 * Updates a single row in the Ab04b61s00 table.
	 * 
	 * comunicacionPrl ComunicacionPrl platea the platea OS3
	 * 
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @param platea
	 *            the platea
	 * @return the os3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS3 modificarDatosTabNotificacionOS3(
			ComunicacionPrl comunicacionPrl, boolean platea) {

		// registrar historico cambios
		/*
		 * ComunicacionApertura comunicacionAperturaOld = this
		 * .findComunicAperturaConNotificacion(ab04b61s00); String
		 * comunicacionAperturaOldStr = HistCambiosAperturasUtil
		 * .concatenarCamposApertura("Datos notificación.",
		 * comunicacionAperturaOld); String comunicacionAperturaNewStr =
		 * HistCambiosAperturasUtil .concatenarCamposApertura(
		 * "Datos notificación.", ab04b61s00);
		 * 
		 * HistCambiosAperturas histCambioAperturas = new
		 * HistCambiosAperturas();
		 * histCambioAperturas.setIdape087(comunicacionAperturaOld.getIdape061()
		 * ); if (comunicacionAperturaOld.getMigrado061() != null &&
		 * Constantes.VALUE_SI.equals(comunicacionAperturaOld .getMigrado061()))
		 * { histCambioAperturas.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
		 * } else {
		 * histCambioAperturas.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N); }
		 * 
		 * histCambioAperturas.setRegoriginal087(comunicacionAperturaOldStr);
		 * histCambioAperturas.setRegmidificaciones087(
		 * comunicacionAperturaNewStr); histCambioAperturas.setFecmodif087(new
		 * Date());
		 * histCambioAperturas.setTipocambio087(TipoCambio.MODIFICACION_APERTURA
		 * .getCodigo());
		 * 
		 * this.histCambiosAperturasDao.add(histCambioAperturas);
		 */
		// Localización
		if (comunicacionPrl.getDatosNotificacion() != null
				&& comunicacionPrl.getDatosNotificacion().getCanalnotif066() != null
				&& comunicacionPrl.getDatosNotificacion().getCanalnotif066()
						.equals(Constantes.CANAL_NOTIF_POSTAL)) {
			DatosLocalizacion localizacion = comunicacionPrl
					.getDatosNotificacion().getDatosLocalizacion();
			if (localizacion.getCodLocalizacion067() != null) {
				// Los datos de localización existen. Los actualizamos
				this.datosLocalizacionService.update(localizacion);
			} else {
				// Los datos de localización no existen. Los insertamos
				localizacion = this.datosLocalizacionService.add(localizacion);
				comunicacionPrl.getDatosNotificacion().setDatosLocalizacion(
						localizacion);

			}
		}

		// Datos notificación
		if (comunicacionPrl.getDatosNotificacion() != null) {
			if (comunicacionPrl.getDatosNotificacion().getCanalnotif066() != null
					&& !platea) {
				DatosLocalizacion datosLoc = comunicacionPrl
						.getDatosNotificacion().getDatosLocalizacion();
				if (comunicacionPrl.getDatosNotificacion().getCanalnotif066()
						.equals(Constantes.CANAL_NOTIF_TELEMATICO)) {
					comunicacionPrl.getDatosNotificacion()
							.setDatosLocalizacion(new DatosLocalizacion(null));
				}

				// Los datos de notificación existen. Los actualizamos
				this.datosNotificacionService.update(comunicacionPrl
						.getDatosNotificacion());
				if (comunicacionPrl.getDatosNotificacion().getCanalnotif066()
						.equals(Constantes.CANAL_NOTIF_TELEMATICO)) {
					this.datosLocalizacionService.remove(datosLoc);
				}

				OS3 os3 = OS3.convertComunicacionPrltoOS3(comunicacionPrl);

				os3 = this.os3Dao.modificarDatosTabNotificacionOS3(os3);

			} else {
				// Los datos de notificación no existen. Los insertamos
				DatosNotificacion datosNotif = this.datosNotificacionService
						.add(comunicacionPrl.getDatosNotificacion());
				comunicacionPrl.setDatosNotificacion(datosNotif);
				ComunicacionPrl prlDatosNotif = new ComunicacionPrl();
				prlDatosNotif.setTeros(comunicacionPrl.getTeros());
				prlDatosNotif.setAnoos(comunicacionPrl.getAnoos());
				prlDatosNotif.setNumos(comunicacionPrl.getNumos());

				prlDatosNotif.setDatosNotificacion(datosNotif);

				OS3 os3 = OS3.convertComunicacionPrltoOS3(comunicacionPrl);

				os3 = this.os3Dao.modificarDatosTabNotificacionOS3(os3);
			}
		}

		return OS3.convertComunicacionPrltoOS3(comunicacionPrl);
	}

	/**
	 * Updates a single row in the Ab0461s00 table.
	 * 
	 * os3 OS3 OS3
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS3 modificarDatosTabEmpresaOS3(OS3 os3) {
		return this.os3Dao.modificarDatosTabEmpresaOS3(os3);
	}

	/**
	 * Updates a single row in the Ab0461s00 table.
	 * 
	 * os3 OS3 OS3
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS3 modificarDatosTabPrevencion(OS3 os3) {
		return this.os3Dao.modificarDatosTabPrevencion(os3);
	}

	/**
	 * Updates a single row in the Ab0461s00 table.
	 * 
	 * os3 OS3 OS3
	 * 
	 * @param os3
	 *            the os 3
	 * @return the os3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS3 modificarDatosTabEstadoOS3(OS3 os3) {
		return this.os3Dao.modificarDatosTabEstadoOS3(os3);
	}

	/**
	 * Finds a single row in the Ab04b61s00 table.
	 * 
	 * folderId String Ab04b61s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os3
	 */
	public OS3 findByFolderId(String folderId) {
		return (OS3) this.os3Dao.findByFolderId(folderId);
	}

	/**
	 * Finds a single row in the Ab04b61s00 table.
	 * 
	 * folderId String Ab04b61s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os3
	 */
	public OS3 findByFolderId2(String folderId) {
		return (OS3) this.os3Dao.findByFolderId2(folderId);
	}

	/**
	 * Crea un registro con los datos minimos.
	 * 
	 * OS3
	 * 
	 * @param aux
	 *            the aux
	 * @return the os3
	 */
	public OS3 altaComunicacionOS3Presencial(OS3 aux) {

		OS3 os3 = new OS3();
		List<ErrorField> errores = new ArrayList<ErrorField>();

		if (aux.getDeseaRegistrar061() != null) {
			if ("S".equals(aux.getDeseaRegistrar061())) {
				os3.setDeseaRegistrar061(aux.getDeseaRegistrar061());
				os3.setNumReg061("");
				os3.setFecReg061(null);
			} else if ("N".equals(aux.getDeseaRegistrar061())) {
				os3.setDeseaRegistrar061(aux.getDeseaRegistrar061());
				if (aux.getNumReg061() != null) {
					os3.setNumReg061(aux.getNumReg061());
				} else {
					os3.setNumReg061("");
					errores.add(new ErrorField("aperturas.detalle.numReg",
							"validacion.obligatorio"));
				}
				if (aux.getFecReg061() != null) {
					os3.setFecReg061(aux.getFecReg061());
				} else {
					os3.setFecReg061(null);
					errores.add(new ErrorField("aperturas.detalle.fecReg",
							"validacion.obligatorio"));
				}
			}
		} else {
			os3.setNumReg061("");
			os3.setFecReg061(null);
			errores.add(new ErrorField("aperturas.detalle.deseaRegistrar",
					"validacion.obligatorio"));
		}

		if (aux.getTipdoc061() != null) {
			os3.setTipdoc061(aux.getTipdoc061());
		} else {
			errores.add(new ErrorField("comunicacionPrl.tipoidentif",
					"validacion.obligatorio"));
		}
		if (aux.getNumdoc061() != null) {
			os3.setNumdoc061(aux.getNumdoc061());
		} else {
			errores.add(new ErrorField("comunicacionPrl.numdoc",
					"validacion.obligatorio"));
		}
		if (aux.getNomemp061() != null) {
			os3.setNomemp061(aux.getNomemp061());
		} else {
			errores.add(new ErrorField("comunicacionPrl.nombreEmpresa",
					"validacion.obligatorio"));
		}

		if (aux.getAnoos3061() == null) {
			aux.setAnoos3061(new SimpleDateFormat(Constantes.DATE_PATTERN_YEAR)
					.format(new Date()));
		} else {
			os3.setAnoos3061(aux.getAnoos3061());
		}

		if (aux.getTeros3061() == null) {
			os3.setTeros3061(UtilSeguridad.getInstance()
					.obtenerDelegacionUsuario());
		} else {
			os3.setTeros3061(aux.getTeros3061());
		}

		NumeracionExpediente numApe = null;
		boolean existe = false;
		OS3 os3Aux = new OS3();
		if (aux.getNumos3061() != null) {
			os3.setNumos3061(aux.getNumos3061());
			os3Aux.setTeros3061(os3.getTeros3061());
			os3Aux.setAnoos3061(os3.getAnoos3061());
			os3Aux.setNumos3061(os3.getNumos3061());
			existe = this.os3Dao.findAllCount(os3Aux) > 0;
			if (existe) {
				errores.add(0, new ErrorField("aperturas.nexp",
						"error.existenumape"));

				if (!errores.isEmpty()) {
					throw new ErrorGenericoException(errores);
				}
			}

		} else if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		} else {
			boolean libre = false;
			while (!libre) {
				numApe = new NumeracionExpediente();
				numApe.setTerexp075(os3.getTeros3061());
				numApe.setAnoexp075(os3.getAnoos3061());
				numApe.setTipexp075(TipoExpedienteFolderEnum.OS3
						.getIdTipoExpediente().toString());

				// obtenemos el numero de apertura
				os3.setNumos3061(this.numeracionExpedienteDao
						.obtenerNumExpSiguiente(numApe).intValue());
				os3Aux.setTeros3061(os3.getTeros3061());
				os3Aux.setAnoos3061(os3.getAnoos3061());
				os3Aux.setNumos3061(os3.getNumos3061());
				if (this.os3Dao.findAllCount(os3Aux) == 0) {
					libre = true;
				} else {
					// actualizar numero de apertura
					this.numeracionExpedienteDao
							.actualizarNumExpSiguiente(numApe);
				}
			}

		}

		// Realizamos las inserciones en orden

		// Añadimos la OS3
		os3 = this.os3Dao.addPresencial(os3);

		os3.setDatosNotificacion(new DatosNotificacion());
		os3.getDatosNotificacion().setCanalnotif066(
				Constantes.CANAL_NOTIF_TELEMATICO);
		if (Constantes.LOCALE_ES.equals(LocaleContextHolder.getLocale())) {
			os3.getDatosNotificacion().setIdioma066(
					Constantes.IDIOMA_NOTIF_CASTELLANO);
		} else if (Constantes.LOCALE_EU.equals(LocaleContextHolder.getLocale())) {
			os3.getDatosNotificacion().setIdioma066(
					Constantes.IDIOMA_NOTIF_EUSKERA);
		}
		os3.getDatosNotificacion()
				.setDatosLocalizacion(new DatosLocalizacion());

		// Los datos de notificación no existen. Los insertamos
		DatosNotificacion datosNotif = this.datosNotificacionService.add(os3
				.getDatosNotificacion());
		os3.setDatosNotificacion(datosNotif);

		this.os3Dao.modificarDatosTabNotificacionOS3(os3);

		if (aux.getNumos3061() == null) {
			// actualizar numero de apertura
			this.numeracionExpedienteDao.actualizarNumExpSiguiente(numApe);
		}

		return os3;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.OS3Service#updateFilled(com.ejie.ab04b.model.OS3)
	 */
	@Override
	public OS3 updateFilled(OS3 os3) {
		return this.os3Dao.updateFilled(os3);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.OS3Service#modificarDatosRegistro(com.ejie.ab04b.
	 * model.OS3)
	 */
	@Override
	public OS3 modificarDatosRegistro(OS3 os3) {
		return this.os3Dao.modificarDatosRegistro(os3);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.OS3Service#updateUsuariosTramitacion(com.ejie.
	 * ab04b.model.OS3)
	 */
	@Override
	public void updateUsuariosTramitacion(OS3 os3) {
		this.os3Dao.updateUsuariosTramitacion(os3);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.OS3Service#updateEstado(com.ejie.ab04b.model.OS3)
	 */
	@Override
	public void updateEstado(OS3 os3) {
		this.os3Dao.updateEstado(os3);

	}

	@Override
	public void updateBatchSub(OS3 os3) {
		this.os3Dao.updateBatchSub(os3);

	}

	@Override
	public void updateFecSub(OS3 os3) {
		this.os3Dao.updateFecSub(os3);

	}
}
